#ifndef USBPKTDEFS_H
#define USBPKTDEFS_H

#include "batterymeter.h"

typedef union _BOOT_DATA_PACKET
{
    byte _byte[BOOT_EP_SIZE];  //For Byte Access
    struct
    {
		union
		{
			ram far byte *pAdrRam;
			struct
			{
				byte low;
				byte high;
				byte upper;
			};
		} ADRA;
		byte dummy;
		MEM_PTR	pAdr;
        byte dummy2;
        enum
        {
			BATT_METER_RW_RAM						=0xC0,
			BATT_METER_RW_ROM						=0xC1,
			BATT_METER_RW_EE						=0xC2,
			BATT_METER_SET_IMODE					=0xC3,
			BATT_METER_RESET						=0xC4,
			BATT_METER_POP_RLE_DATA					=0xC5,
			BATT_METER_READF						=0xC6,
			BATT_METER_WRITEF						=0xC7,
			RESET                   	 			=0xFF
        } CMD;
		byte 	dir;
		byte	varn;
		byte 	index;
	    int 	len;					// number of bytes
		int		iarg;					// integer argument
        byte data[DATA_SIZE];			// the rest of the frame.
    };

} BOOT_DATA_PACKET;

#endif
